from __future__ import generators
import plus
import Arenas
import Hazards
import random
#import Gooey
import math

class RingArena(Arenas.SuperArena):
    "The Robot Wars 2016 arena. Let The Wars Begin!"
    name = "Robot Wars Studio 2016"
    preview = "robotwars2016/rw2016_preview.bmp"
    game_types = ['DEATHMATCH', 'BATTLE ROYAL', 'TEAM MATCH']

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/robotwars2016/robotwars2016.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)
        fmod = 0.015
        degrad = 0.01745
        self.AddStaticCamera("Door Cam", (1.8, 13, -17), (40*degrad, 0), degrad*62)
        self.AddStaticCamera("Birds Eye", (0, 55.8, 2), (90*degrad, 90*degrad), degrad*37)
        self.AddStaticCamera("Random Cam", (13, 9, -17), (.367, -40*degrad), degrad*55)

        self.AddWatchCamera("Overhead", (2.5, 10, -15), (20, 30, 60*degrad, 20*degrad))
        self.AddWatchCamera("Roboteer View", (11.6, 11.5, 22.5), (20, 30, 60*degrad, 20*degrad))
        self.AddWatchCamera("Arena cam 1", (-14, 9, 18), (20, 30, 60*degrad, 20*degrad))
        self.AddWatchCamera("Arena cam 2", (-9.3, 8, -14.7), (16, 22, 30*degrad, 20*degrad))

        self.AddSound = plus.createSound("Sounds/rwarenaloop4.wav", False, (0, 0, 0))
        plus.loopSound(self.AddSound)
        self.botinzone = 0
        self.botinzone2 = 0
        self.flippertimer = 0
        self.pittimer = 0
        self.players = ()
        self.SetPinned ("pit_display", True)
        # POSITION TRACKER: set up text box and turn off immobility for hazard positioning.
        # self.tauntbox = Gooey.Plain("taunt", 10, 175, 640, 175)
        # tbox = self.tauntbox.addText("taunt1", 10, 0, 640, 15)
        # tbox.setText("")
        # plus.practice(1)
		
    def __del__(self):
        if self.AddSound:
            plus.stopSound(self.AddSound)
            plus.removeSound(self.AddSound)
        Arenas.SuperArena.__del__(self)

    def AddShadowReceivers(self):
        pass
        
    def HazardsOn(self, on):
        # walls
        self.AddCollisionLine((18, 18), (18, -14))
        self.AddCollisionLine((18, -14), (-14, -14))
        self.AddCollisionLine((-14, -14), (-14, 18))
        self.AddCollisionLine((-14, 18), (18, 18))
        if on:
            # flipper
            hinge = self.GetHinge("Hinge01")
            self.RegisterZone("flipperzone", 1)
            self.Hell1 = Hazards.HellRaiser(hinge, (7.73682, 4.86408, 10.3182))
            self.AddHazard(self.Hell1)
            # pit
            self.prism = self.AddPrismatic("arena_display", "pit_display", 0, -2, 0, 0, 0, 0)
            self.prism.SetAutoLock(False)
            self.RegisterZone("pitzone", 2)
            self.pitsiren = plus.createSound("Sounds/pit_siren.wav", False, (0, 0, 0))
            # spikes
            self.AddCollisionLine((10.6, -3.5), (8, -3.5))
            self.AddCollisionLine((8, -3.5), (8, -6.3))
            self.AddCollisionLine((8, -6.3), (10.6, -6.3))
            self.AddCollisionLine((10.6, -6.3), (10.6, -3.5))
            self.AddPOV(0, (11.6, -2.5), (1, 3))
            self.AddPOV(1, (7, -2.5), (0, 2))
            self.AddPOV(2, (7, -7.3), (1, 3))
            self.AddPOV(3, (11.6, -7.3), (2, 0))
            prism1 = self.AddPrismatic("arena_display", "spike1", 0, 1, 0, 0, 1.2, 0)
            self.spike1 = Hazards.Spikes(prism1, 80000, (9.3, 0, -4.9))
            self.AddHazard(self.spike1)
            self.RegisterZone("spikezone1", 3)
            self.SetSubMaterialSound("spike1", "metal", 1, "Sounds\\hzd_spike_hit.wav")
            prism2 = self.AddPrismatic("arena_display", "spike2", 0, 1, 0, 0, 1.2, 0)
            self.spike2 = Hazards.Spikes(prism2, 80000, (10.6, 0, -3.5))
            self.AddHazard(self.spike2)
            self.RegisterZone("spikezone2", 4)
            self.SetSubMaterialSound("spike2", "metal", 1, "Sounds\\hzd_spike_hit.wav")
            prism3 = self.AddPrismatic("arena_display", "spike3", 0, 1, 0, 0, 1.2, 0)
            self.spike3 = Hazards.Spikes(prism3, 80000, (8, 0, -3.5))
            self.AddHazard(self.spike3)
            self.RegisterZone("spikezone3", 5)
            self.SetSubMaterialSound("spike3", "metal", 1, "Sounds\\hzd_spike_hit.wav")
            prism4 = self.AddPrismatic("arena_display", "spike4", 0, 1, 0, 0, 1.2, 0)
            self.spike4 = Hazards.Spikes(prism4, 80000, (8, 0, -6.3))
            self.AddHazard(self.spike4)
            self.RegisterZone("spikezone4", 6)
            self.SetSubMaterialSound("spike4", "metal", 1, "Sounds\\hzd_spike_hit.wav")
            prism5 = self.AddPrismatic("arena_display", "spike5", 0, 1, 0, 0, 1.2, 0)
            self.spike5 = Hazards.Spikes(prism5, 80000, (10.6, 0, -6.3))
            self.AddHazard(self.spike5)
            self.RegisterZone("spikezone5", 7)
            self.SetSubMaterialSound("spike5", "metal", 1, "Sounds\\hzd_spike_hit.wav")
            # flame pit
            self.RegisterZone("flamezone", 8)
            self.flame6 = Hazards.Flame((-5.8, 4.85, 9.9), (0, 7.5, 0), (5, 1.5, 5), 0.1)
            self.AddHazard(self.flame6)
            self.flame7 = Hazards.Flame((-5.8, 4.85, 10.9), (0, 7.5, 0), (5, 1.5, 5), 0.1)
            self.AddHazard(self.flame7)
            self.flame8 = Hazards.Flame((-4.8, 4.85, 10.9), (0, 7.5, 0), (5, 1.5, 5), 0.1)
            self.AddHazard(self.flame8)
            self.flame9 = Hazards.Flame((-4.8, 4.85, 9.9), (0, 7.5, 0), (5, 1.5, 5), 0.1)
            self.AddHazard(self.flame9)
        else:
            # hazards should be in their "hidden" position
            pass
        return Arenas.SuperArena.HazardsOn(self, on)

    def Activate(self, on):    
        if on: self.players = plus.getPlayers()
        return Arenas.SuperArena.Activate(self, on)
        
    def Introduction(self):
        sounds = self.intro_sounds
        
        # set initial camera & fade from black
        plus.setCameraPosition(-45,35,-45)
        plus.setCameraRotation(0.4012, 0.78539)
        plus.setCameraFOV(0.7753)
        plus.fadeFromBlack(.25)

        #start playing music loop
        self.intro_music = plus.createSound("Sounds/announcers/rwsilence.wav", False, (0,0,0))
        plus.setVolume(self.intro_music, 0, 0)
        plus.loopSound(self.intro_music)
        yield .25
        
        #load all sounds now to decrease lag later
        sounds['crowd'] = plus.createSound("Sounds/crowd/LoudCheer_Loop.wav", False, (0,0,0))
        
        arenaOpt = ("Sounds/announcers/rwringintro1.wav", "Sounds/announcers/rwringintro2.wav")
        sounds['arena'] = plus.createSound(random.choice(arenaOpt), False, (0,0,0))
        genericOpt = ("rwsilence.wav", "rwsilence.wav", "rwsilence.wav", "rwsilence.wav", "rwsilence.wav", "rwsilence.wav", "Irwsilence.wav", "rwsilence.wav")
        sounds['generic'] = plus.createSound("Sounds/announcers/"+random.choice(genericOpt), False, (0,0,0))
        botOpt = ("Bots_YouCanFeelTension.wav", "Bots_ColdChill.wav", "Bots_FansLoveTheseBots.wav", "Bots_SeeingInterestingDesigns.wav", "Bots_CrowdPoisedBotsArmed.wav")
        sounds['bots'] = plus.createSound("Sounds/announcers/"+random.choice(botOpt), False, (0,0,0))
        
        #intro cam, welcom comment
        plus.playSound(sounds['arena'])
        plus.fadeInToLoop(sounds['crowd'], -100, 800)
        plus.animateCamera((-45,35,-45), (0.4012, 0.78539), 0.7753, (45,35,-45), (0.4012, -0.78539), 0.7753, 0, 8)
        yield 2
        plus.fadeOutLoop(sounds['crowd'], 8000)
        yield 1
        
        #play a generic (or specific) secondary comment
        plus.playSound(sounds['generic'])
        yield 5

        pcount = len(self.players)
        if pcount>0: plus.playSound(sounds['bots'])
        delaytime = 6 - pcount
        
        if 0 in self.players:
            #bot 1 cam
            plus.animateCamera((10,20,0), (0.533,-1.57), 0.6, (10,20,0), (0.533,-1.57), 0.45, 0, delaytime)
            yield delaytime
            
        if 1 in self.players:
            #bot 2 cam
            plus.animateCamera((-10,20,0), (0.533,1.57), 0.6, (-10,20,0), (0.533,1.57), 0.45, 0, delaytime)
            yield delaytime
            
        if 2 in self.players:
            #bot 3 cam
            plus.animateCamera((0,20,-10), (0.533,0), 0.6, (0,20,-10), (0.533,0), 0.45, 0, delaytime)
            yield delaytime
            
        if 3 in self.players:
            #bot 4 cam
            plus.animateCamera((0,20,10), (0.533,3.14), 0.6, (0,20,10), (0.533,3.14), 0.45, 0, delaytime)
            yield delaytime
            
        #fade out music
        plus.fadeOutLoop(self.intro_music, 2000)
        yield 2
        
        # done
        yield 0
        
    def Tick(self):
        if self.bHazardsOn:
            # flipper
            self.Hell1.Tick()
            if self.botinzone >= 1:
                self.flippertimer += 1
            else:
                self.flippertimer = 0
            if self.flippertimer >= 10:
                self.Hell1.RaiseHell()
                self.flippertimer = 0
            # pit
            if self.pittimer == 1:
                # add collision lines as soon as the pit release triggers and play siren
                self.AddCollisionLine((-8.31869, -7.73154), (-2.28282, -7.73154))
                self.AddCollisionLine((-2.28282, -7.73154), (-8.31869, -1.7187))
                self.AddCollisionLine((-8.31869, -1.7187), (-2.28282, -1.7187))
                self.AddCollisionLine((-2.28282, -1.7187), (-8.31869, -7.73154))
                self.AddPOV(0, (-9.31869, -8.73154), (1, 3))
                self.AddPOV(1, (-1.28282, -8.73154), (0, 2))
                self.AddPOV(2, (-9.31869, -0.7187), (1, 3))
                self.AddPOV(3, (-1.28282, -0.7187), (2, 0))
                plus.playSound(self.pitsiren)
            if 0 < self.pittimer < 16:
                self.pittimer += 1
                self.SetPinned ("pit_display", False)
                self.prism.Lock(False)
                self.prism.ApplyForce(1)
            if self.pittimer == 16:
                self.SetPinned ("pit_display", True)
                self.prism.Lock(True)
            # spikes
            self.spike1.Tick()
            self.spike2.Tick()
            self.spike3.Tick()
            self.spike4.Tick()
            self.spike5.Tick()
            # flames
            self.flame6.Tick()
            self.flame7.Tick()
            self.flame8.Tick()
            self.flame9.Tick()
        # POSITION TRACKER: update text box every tick with current X,Z coordinates.
        # self.tauntbox.get("taunt1").setText(str(plus.getLocation(0)[0]) + ", " + str(plus.getLocation(0)[2]))
        for each in self.players:
            if plus.getLocation(each)[1] < 4.6 or (plus.getLocation(each)[1] < 6 and not -15 < plus.getLocation(each)[0] < 19) or (plus.getLocation(each)[1] < 6 and not -15 < plus.getLocation(each)[2] < 19):
                plus.eliminatePlayer(each)        
        return Arenas.SuperArena.Tick(self)

    def ZoneEvent(self, direction, id, robot, chassis):
        if id==1 and direction==1:
            self.botinzone += 1
        elif id==1 and direction==-1:
            self.botinzone -= 1
        if id==2 and direction==1 and self.pittimer==0:
            self.pittimer = 1
        elif id == 3:
            self.spike1.ZoneEvent(direction)
        elif id == 4:
            self.spike2.ZoneEvent(direction)
        elif id == 5:
            self.spike3.ZoneEvent(direction)
        elif id == 6:
            self.spike4.ZoneEvent(direction)
        elif id == 7:
            self.spike5.ZoneEvent(direction)
        elif id == 8:
            self.flame6.ZoneEvent(direction)
            self.flame7.ZoneEvent(direction)
            self.flame8.ZoneEvent(direction)
            self.flame9.ZoneEvent(direction)
        return True

Arenas.register(RingArena)
